<?php
/**
 * Hook For Google Fonts
 */
/**
 * @Mailchimp List
 * @return 
 */
if (!function_exists('dexterity_mailchimp_list')) {

    function dexterity_mailchimp_list() {
        $mailchimp_list[] = '';
        $mailchimp_list[0] = 'Select List';
        $mailchimp_option = '';
        if (!function_exists('fw_get_db_settings_option')) {
            $mailchimp_option = '';
        } else {
            $default_value = 'b1c640ffabcea48f48530987ffdae147-us11';

            $mailchimp_option = fw_get_db_settings_option('mailchimp_key', $default_value);
            if (isset($mailchimp_option) && !empty($mailchimp_option)) {
                $mailchimp_option = $mailchimp_option;
            } else {
                $mailchimp_option = '';
            }
        }

        if ($mailchimp_option <> '') {
            $mailchim_obj = new Dexterity_MailChimp();
            $lists = $mailchim_obj->dexterity_mailchimp_list($mailchimp_option);
            if (is_array($lists) && isset($lists['data'])) {
                foreach ($lists['data'] as $list) {
                    if (!empty($list['name'])) :
                        $mailchimp_list[$list['id']] = $list['name'];
                    endif;
                }
            }
        }

        return $mailchimp_list;
    }

}

/**
 * @Section wraper before
 * @return 
 */
if (!function_exists('dexterity_prepare_section_wrapper_before')) {

    function dexterity_prepare_section_wrapper_before() {
        echo '<div class="main-page-wrapper tg-haslayout">';
    }

    add_action('dexterity_prepare_section_wrapper_before', 'dexterity_prepare_section_wrapper_before');
}
/**
 * @Section wraper after
 * @return 
 */
if (!function_exists('dexterity_prepare_section_wrapper_after')) {

    function dexterity_prepare_section_wrapper_after() {
        echo '</div>';
    }

    add_action('dexterity_prepare_section_wrapper_after', 'dexterity_prepare_section_wrapper_after');
}


/**
 * @Next Prevoius Links
 * @return 
 */
if (!function_exists('dexterity_do_preocess_next_previous_link')) {

    function dexterity_do_preocess_next_previous_link($post_type = 'post') {
        global $post;
        $prevous_post_id = $next_post_id = '';
        $post_type = get_post_type($post->ID);
        $count_posts = wp_count_posts("$post_type")->publish;
        $args = array(
            'posts_per_page' => -1,
            'order' => 'ASC',
            'post_type' => "$post_type",
        );

        $all_posts = get_posts($args);

        $ids = array();
        foreach ($all_posts as $current_post) {
            $ids[] = $current_post->ID;
        }
        $current_index = array_search($post->ID, $ids);

        if (isset($ids[$current_index - 1])) {
            $prevous_post_id = $ids[$current_index - 1];
        }

        if (isset($ids[$current_index + 1])) {
            $next_post_id = $ids[$current_index + 1];
        }
        ?>
        <div class="buttons">
            <?php
            if (isset($prevous_post_id) && !empty($prevous_post_id) && $prevous_post_id >= 0) {
                ?>
                <a class="prev-post" href="<?php echo esc_url(get_permalink($prevous_post_id)); ?>"><?php esc_html_e('Previous Post', 'dexterity'); ?></a>
                <?php
            }
            if (isset($next_post_id) && !empty($next_post_id)) {
                ?>
                <a class="next-post" href="<?php echo esc_url(get_permalink($next_post_id)); ?>"><?php esc_html_e('Next Post', 'dexterity'); ?></a>
        <?php } ?>
        </div>
        <?php
        wp_reset_postdata();
    }

    add_action('do_preocess_next_previous_link', 'dexterity_do_preocess_next_previous_link');
}

/**
 * @Wp Login
 * @return 
 */
if (!function_exists('dexterity_ajax_login')) {

    function dexterity_ajax_login() {

        $user_array = array();
        $user_array['user_login'] = esc_sql($_POST['username']);
        $user_array['user_password'] = esc_sql($_POST['password']);

        if (isset($_POST['rememberme'])) {
            $remember = esc_sql($_POST['rememberme']);
        } else {
            $remember = '';
        }

        if ($remember) {
            $user_array['remember'] = true;
        } else {
            $user_array['remember'] = false;
        }

        if ($user_array['user_login'] == '') {
            echo json_encode(array('type' => 'error', 'loggedin' => false, 'message' => esc_html__('User name should not be empty.', 'dexterity')));
            exit();
        } elseif ($user_array['user_password'] == '') {
            echo json_encode(array('type' => 'error', 'loggedin' => false, 'message' => esc_html__('Password should not be empty.', 'dexterity')));
            exit();
        } else {
            $status = wp_signon($user_array, false);
            if (is_wp_error($status)) {
                echo json_encode(array('type' => 'error', 'loggedin' => false, 'message' => esc_html__('Wrong username or password.', 'dexterity')));
            } else {
                echo json_encode(array('type' => 'success', 'url' => esc_url( home_url('/') ), 'loggedin' => true, 'message' => esc_html__('Successfully Login', 'dexterity')));
            }
        }

        die();
    }

    add_action('wp_ajax_dexterity_ajax_login', 'dexterity_ajax_login');
    add_action('wp_ajax_nopriv_dexterity_ajax_login', 'dexterity_ajax_login');
}

/**
 * @Wp Registration
 * @return 
 */
if (!function_exists('dexterity_user_registration')) {

    function dexterity_user_registration($atts = '') {
        global $wpdb;

        $username = esc_sql($_POST['username']);
        $terms = $_POST['terms'];
        $password = esc_sql($_POST['password']);
        $confirm_password = esc_sql($_POST['confirm-password']);

        $json = array();

        if (empty($username)) {
            $json['type'] = "error";
            $json['message'] = "User name should not be empty.";
            echo json_encode($json);
            exit();
        }

        if ($terms == '0') {
            $json['type'] = "error";
            $json['message'] = "Please Check Terms and Conditions";
            echo json_encode($json);
            exit();
        }

        if (empty($password)) {
            $json['type'] = "error";
            $json['message'] = "Password is required.";
            echo json_encode($json);
            exit();
        }

        if ($password != $confirm_password) {
            $json['type'] = "error";
            $json['message'] = esc_html__("Password is not matched.", 'dexterity');
            echo json_encode($json);
            exit();
        }

        $email = esc_sql($_POST['useremail']);
        if (empty($email)) {
            $json['type'] = "error";
            $json['message'] = esc_html__("Email should not be empty.", 'dexterity');
            echo json_encode($json);
            exit();
        }

        if (!preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$/", $email)) {

            $json['type'] = "error";
            $json['message'] = esc_html__("Please enter a valid email.", 'dexterity');
            echo json_encode($json);
            die;
        }
        $random_password = $password;

        $role = 'subscriber';

        $status = wp_create_user($username, $random_password, $email);
        if (is_wp_error($status)) {
            $json['type'] = "error";
            $json['message'] = esc_html__("User already exists. Please try another one.", 'dexterity');
            echo json_encode($json);
            die;
        } else {
            global $wpdb;
            wp_update_user(array('ID' => esc_sql($status), 'role' => esc_sql($role), 'user_status' => 1));
            $wpdb->update(
                    $wpdb->prefix . 'users', array('user_status' => 1), array('ID' => esc_sql($status))
            );
            update_user_meta($status, 'show_admin_bar_front', false);
            wp_new_user_notification(esc_sql($status), $random_password);
            $json['type'] = "success";
            $json['message'] = esc_html__("Please check your email for login details.", "dexterity");
            echo json_encode($json);
            die;
        }
        die();
    }

    add_action('wp_ajax_dexterity_user_registration', 'dexterity_user_registration');
    add_action('wp_ajax_nopriv_dexterity_user_registration', 'dexterity_user_registration');
}


/**
 * @User Profile Social Icons
 * @return 
 */
if (!function_exists('dexterity_user_social_mehthods')) {

    function dexterity_user_social_mehthods($userid) {
        $userfields['facebook'] = 'Facebook';
        $userfields['twitter'] = 'Twitter';
        $userfields['linkedin'] = 'Linkedin';
        $userfields['pinterest'] = 'Pinterest';
        $userfields['google_plus'] = 'Google Plus';
        $userfields['instagram'] = 'Instagram';
        $userfields['tumblr'] = 'Tumblr';
        $userfields['skype'] = 'Skype';
        return $userfields;
    }

    add_filter('user_contactmethods', 'dexterity_user_social_mehthods', 10, 1);
}


/**
 * @User Profile Social Icons
 * @return 
 */
if (!function_exists('dexterity_replace_reply_link_class')) {

    function dexterity_replace_reply_link_class($class) {
        $class = str_replace("class='comment-reply-link", "class='tg-reply", $class);
        return $class;
    }

    add_filter('comment_reply_link', 'dexterity_replace_reply_link_class');
}


/**
 * @Add Body Class
 * @return 
 */
if (!function_exists('dexterity_content_classes')) {

    function dexterity_content_classes($classes) {
        $post_name = dexterity_get_post_name();
        if (( isset($maintenance) && $maintenance == 'enable' && !is_user_logged_in() ) || $post_name == "coming-soon") {
            $classes[] = 'comming-soon-bg ';
        } else {
            if (is_home() || is_front_page()) {
                $classes[] = 'home ';
            }
        }

        $classes[] = dexterity_get_post_name('true'); //Demo Purpose
        //Header Classes
        if (is_home() || is_front_page()) {
            $classes[] = 'mec-home';
        }

        $classes[] = 'tg-inner-header ';
        return $classes;
    }

    add_filter('body_class', 'dexterity_content_classes', 1);
}



/**
 * @submit contact
 * @return 
 */
if (!function_exists('dexterity_submit_contact')) {

    function dexterity_submit_contact() {
        global $current_user;

        $json = array();

        $do_check = check_ajax_referer('dexterity_submit_contact', 'contact_security', false);
        if ($do_check == false) {
            $json['type'] = 'error';
            $json['message'] = esc_html__('No kiddies please!', 'dexterity');
            echo json_encode($json);
            die;
        }

        $bloginfo = get_bloginfo();
        $subject_message = "(" . $bloginfo . ") Contact Form Received";
        $dexterity_message = esc_html__('Message Sent.', 'dexterity');
        $failure_message = esc_html__('Message Fail.', 'dexterity');

        $recipient = get_option('admin_email', 'info@themographics.com');

        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            // Get the form fields and remove whitespace.

            if ($_POST['username'] == '' || $_POST['userphone'] == '' || $_POST['useremail'] == '' || $_POST['website'] == '' || $_POST['description'] == '') {
                $json['type'] = 'error';
                $json['message'] = esc_html__('Please fill all fieldsaa.', 'dexterity');
                echo json_encode($json);
                die;
            }

            if (!dexterity_isValidEmail($_POST['useremail'])) {
                $json['type'] = 'error';
                $json['message'] = esc_html__('Email address is not valid.', 'dexterity');
                echo json_encode($json);
                die;
            }

            $username  = $_POST['username'];
            $email 	 = $_POST['useremail'];
            $userphone = $_POST['userphone'];
            $website = $_POST['website'];
            $message = $_POST['description'];

            // Set the email subject.
            $subject = $subject_message;

			//Email
			$obj	= new DexterityProcessEmail();
			$email_data	= array();
			$email_data['username']   = $username;
			$email_data['subject']	= $subject;
			$email_data['email']	  = $email;
			$email_data['userphone']  = $userphone;
			$email_data['website']	= $website;
			$email_data['message']	= $message;

			$obj->process_contact_email($email_data);
			
            // Send the email.
            $json['type'] = "success";
			$json['message'] = esc_attr($dexterity_message);
			echo json_encode($json);
			die();
			
        } else {
            // Not a POST request, set a 403 (forbidden) response code.
            // http_response_code(403);
            echo
            $json['type'] = "error";
            $json['message'] = esc_attr($failure_message);
            echo json_encode($json);
            die();
        }
    }

    add_action('wp_ajax_dexterity_submit_contact', 'dexterity_submit_contact');
    add_action('wp_ajax_nopriv_dexterity_submit_contact', 'dexterity_submit_contact');
}

/**
 * @Validaet Email
 * @return {}
 */
if (!function_exists('dexterity_isValidEmail')) {

    function dexterity_isValidEmail($email) {
        return filter_var($email, FILTER_VALIDATE_EMAIL);
    }

}

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function dexterity_body_classes($classes) {
    // Adds a class of group-blog to blogs with more than 1 published author.
    if (is_multi_author()) {
        $classes[] = 'group-blog';
    }

    if (function_exists('fw_get_db_settings_option')) {
        $maintenance = fw_get_db_settings_option('maintenance');
		$sticky_header = fw_get_db_settings_option('sticky_header');
    } else {
        $maintenance = '';
		$sticky_header = '';
    }

    $post_name = dexterity_get_post_name();
    if (( isset($maintenance) && $maintenance == 'enable' && !is_user_logged_in() ) || $post_name === "coming-soon") {
        $classes[] = 'tg-comming-soon';
    }
	
	if( isset( $sticky_header ) && $sticky_header === 'enable' ){
		$classes[] = 'sticky-enabled';
	}

    return $classes;
}

add_filter('body_class', 'dexterity_body_classes');

/**
 * @Product Image 
 * @return {}
 */
function _prepare_post_thumbnail($object, $atts) {
    extract(shortcode_atts(array(
        "width" => '300',
        "height" => '300',
                    ), $atts));

    if (isset($object) && !empty($object)) {
        return $object;
    } else {
        $object_url = get_template_directory_uri() . '/images/placeholder-' . $width . 'x' . $height . '.png';
        return '<img width="' . $width . '" height="' . $height . '" src="' . $object_url . '" alt="' . esc_html__('Placeholder', 'dexterity') . '">';
    }
}

add_filter('_prepare_post_thumbnail', '_prepare_post_thumbnail', 10, 3);

/**
 * @post type view
 * @return 
 */
if (!function_exists('dexterity_remove_row_actions')) {
    add_filter('post_row_actions', 'dexterity_remove_row_actions', 10, 1);

    function dexterity_remove_row_actions($actions) {
        if (get_post_type() === 'tg_slider' || get_post_type() === 'tg_portfolios' || get_post_type() === 'table_bookings' || get_post_type() === 'tg_appointments' || get_post_type() === 'tg_vehicle_type') {
            unset($actions['view']);
        }
        return $actions;
    }

}

/**
 * @submit appointment
 * @return 
 */
if (!function_exists('dexterity_submit_appointment')) {

    function dexterity_submit_appointment() {
        global $current_user;
        wp_get_current_user();

        $json = array();

        $do_check = check_ajax_referer('dexterity_submit_appointment', 'security', false);
        if ($do_check == false) {
            $json['type'] = 'error';
            $json['message'] = esc_html__('No kiddies please!', 'dexterity');
            echo json_encode($json);
            die;
        }

        if ($_POST['appointment']['apt_name'] == '' 
			|| $_POST['appointment']['apt_email'] == '' 
			|| $_POST['appointment']['apt_phone'] == '' 
			|| $_POST['appointment']['apt_message'] == '' 
			|| $_POST['appointment']['apt_date'] == ''
		) {
            $json['type'] = 'error';
            $json['message'] = esc_html__('Please fill all fields.', 'dexterity');
            echo json_encode($json);
            die;
        }
        if (!dexterity_isValidEmail($_POST['appointment']['apt_email'])) {
            $json['type'] = 'error';
            $json['message'] = esc_html__('Email address is not valid..', 'dexterity');
            echo json_encode($json);
            die;
        }
		
		$appointment_no	= esc_html__('Appointment #', 'dexterity') . rand(99, 99999);
        $json = array();
        $old_values = array();
        $appointment_post = array(
            'post_title' => $appointment_no,
            'post_content' => $_POST['appointment']['apt_message'],
            'post_status' => 'publish',
            'post_author' => $current_user->ID,
            'post_type' => 'tg_appointments',
            'post_date' => current_time('Y-m-d h:i:s')
        );

        $post_id = wp_insert_post($appointment_post);
        $new_values = $_POST['appointment'];
        if (isset($post_id) && !empty($post_id)) {
            fw_set_db_post_option(
                    $post_id, null, // this means it will replace all option values, not only a specific option_id
                    array_merge($old_values, $new_values)
            );

            $json['type'] = 'dexterity';
            $json['message'] = esc_html__('Your appointmnet has been submitted, please check your email ', 'dexterity');
			
			
			//Email
			$obj	= new DexterityProcessEmail();
			$email_data	= array();
			$email_data['appointment_no']	= $appointment_no;
			$email_data['apt_name']		  = $_POST['appointment']['apt_name'];
			$email_data['apt_email']		 = $_POST['appointment']['apt_email'];
			$email_data['apt_phone']		 = $_POST['appointment']['apt_phone'];
			$email_data['apt_message']	   = $_POST['appointment']['apt_message'];
			$email_data['apt_date']		  = $_POST['appointment']['apt_date'];
			$email_data['apt_services']	  = $_POST['appointment']['apt_services'];
			
			$obj->process_appointment_email($email_data);
			
        } else {
            $json['type'] = 'error';
            $json['message'] = esc_html__('Some error occur, please try again latter.', 'dexterity');
        }

        echo json_encode($json);
        die;
    }

    add_action('wp_ajax_dexterity_submit_appointment', 'dexterity_submit_appointment');
    add_action('wp_ajax_nopriv_dexterity_submit_appointment', 'dexterity_submit_appointment');
}


/**
 * @submit appointment
 * @return 
 */
if (!function_exists('dexterity_add_class_to_tags')) {

    function dexterity_add_class_to_tags($html) {
        $html = str_replace('<a', '<a class="tg-tag"', $html);
        return $html;
    }

    add_filter('the_tags', 'dexterity_add_class_to_tags');
}