<?php
if (!defined('ABSPATH')) {
    die('Direct access forbidden.');
}

if (!class_exists('TG_Address_Widget')) {

    class TG_Address_Widget extends WP_Widget {
        /*
         * @init About Dexterity
         * 
         */

        public function __construct() {
            $widget_ops = array('classname' => 'address-column', 'description' => 'Display Address Widget');
            $control_ops = array('width' => 300, 'height' => 250, 'id_base' => 'address_widget');
            parent::__construct('address_widget', esc_html__('TG Address Widget', 'dexterity'), $widget_ops, $control_ops);
        }

        /**
         * About Dexterity form
         *
         */
        public function form($instance) {
            $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
            $logo_url = isset($instance['logo_url']) ? esc_attr($instance['logo_url']) : '';
            $address = isset($instance['address']) ? esc_attr($instance['address']) : '';
            $email = isset($instance['email']) ? esc_attr($instance['email']) : '';
            $phone = isset($instance['phone']) ? esc_attr($instance['phone']) : '';
            $description = isset($instance['description']) ? esc_attr($instance['description']) : '';
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'dexterity'); ?></label>
                <input type="text" id="title" name="<?php echo esc_attr($this->get_field_name('title')); ?>" value="<?php echo esc_attr($title); ?>" class="widefat" />
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('logo_url')); ?>"><?php esc_html_e('Logo URL:', 'dexterity'); ?></label>
                <input type="text" id="logo_url" name="<?php echo esc_attr($this->get_field_name('logo_url')); ?>" value="<?php echo esc_attr($logo_url); ?>" class="widefat" />
            </p>
            <p>
                <label for="description"><?php esc_html_e('Description:', 'dexterity'); ?></label>

                <textarea id="description"  rows="8" cols="10" name="<?php echo esc_attr($this->get_field_name('description')); ?>" class="widefat"><?php echo force_balance_tags($description); ?></textarea>
                <span><?php esc_html_e('Shortcodes And HTML Tags are allowed.', 'dexterity'); ?></span>
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('address')); ?>"><?php esc_html_e('Address:', 'dexterity'); ?></label>
                <input type="text" id="address" name="<?php echo esc_attr($this->get_field_name('address')); ?>" value="<?php echo esc_attr($address); ?>" class="widefat" />
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('email')); ?>"><?php esc_html_e('Email:', 'dexterity'); ?></label>
                <input type="text" id="email" name="<?php echo esc_attr($this->get_field_name('email')); ?>" value="<?php echo esc_attr($email); ?>" class="widefat" />
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('phone')); ?>"><?php esc_html_e('Phone:', 'dexterity'); ?></label>
                <input type="text" id="phone" name="<?php echo esc_attr($this->get_field_name('phone')); ?>" value="<?php echo esc_attr($phone); ?>" class="widefat" />
            </p>

            <?php
        }

        /**
         * @Update About Dexterity 
         *
         */
        public function update($new_instance, $old_instance) {
            $instance = $old_instance;
            $instance['title'] = (!empty($new_instance['title']) ) ? strip_tags($new_instance['title']) : '';
            $instance['description'] = (!empty($new_instance['description']) ) ? $new_instance['description'] : '';
            $instance['logo_url'] = (!empty($new_instance['logo_url']) ) ? strip_tags($new_instance['logo_url']) : '';
            $instance['address'] = (!empty($new_instance['address']) ) ? $new_instance['address'] : '';
            $instance['email'] = (!empty($new_instance['email']) ) ? strip_tags($new_instance['email']) : '';
            $instance['phone'] = (!empty($new_instance['phone']) ) ? $new_instance['phone'] : '';

            return $instance;
        }

        /**
         * @Display About Dexterity
         *
         *
         */
        public function widget($args, $instance) {
            extract($args);
            $title = empty($instance['title']) ? '' : $instance['title'];
            $description = empty($instance['description']) ? '' : $instance['description'];
            $logo_url = empty($instance['logo_url']) ? '' : $instance['logo_url'];
            $address = empty($instance['address']) ? '' : $instance['address'];
            $email = empty($instance['email']) ? '' : $instance['email'];
            $phone = empty($instance['phone']) ? '' : $instance['phone'];

            echo dexterity_esc_specialchars($args['before_widget']);

            if (!empty($title) && $title != '') {
                echo dexterity_esc_specialchars($args['before_title'] . apply_filters('widget_title', esc_attr($title)) . $args['after_title']);
            }
            ?>
            <?php if (!empty($logo_url)) { ?>
                <strong class="tg-logo">
                    <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($logo_url); ?>" alt="<?php echo get_bloginfo('name'); ?>"></a>
                </strong>
            <?php } ?>
            <?php if (!empty($description)) { ?>
                <div class="tg-description">
                    <p><?php echo do_shortcode($description); ?></p>
                </div>
            <?php } ?>
            <?php if (!empty($address) || !empty($email) || !empty($phone)) { ?>
                <ul class="tg-info">
                    <?php if (!empty($address)) { ?>
                        <li><i class="fa fa-home"></i><address><?php echo esc_attr($address); ?></address></li>
                    <?php } ?>
                    <?php if (!empty($email)) { ?>
                        <li><i class="fa fa-envelope-o"></i><a href="info@domain.com"><?php echo esc_attr($email); ?></a></li>
                    <?php } ?>
                    <?php if (!empty($phone)) { ?>
                        <li><i class="fa fa-phone"></i><span><?php echo esc_attr($phone); ?></span></li>
                            <?php } ?>
                </ul>
            <?php } ?>
            <?php
            echo dexterity_esc_specialchars($args['after_widget']);
        }

    }

}
add_action('widgets_init', create_function('', 'return register_widget("TG_Address_Widget");'));
