<?php
if (!defined('ABSPATH')) {
    die('Direct access forbidden.');
}
if (!class_exists('NewsLetter')) {

    class TG_NewsLetter extends WP_Widget {

        /**
         *  @init NewsLetter
         *
         *
         */
        public function __construct() {
            $widget_ops_news = array('classname' => 'news_letter', 'description' => 'Used For News Letter.');
            $control_ops_news = array('width' => 300, 'height' => 250, 'id_base' => 'news_letter');
            parent::__construct('news_letter', esc_html__('TG NewsLetter Widget', 'dexterity'), $widget_ops_news, $control_ops_news);
        }

        /**
         * @ NewsLetter form
         *
         *
         */
        public function form($instance) {
            $title = !empty($instance['title']) ? $instance['title'] : esc_html__('Signup Newletter', 'dexterity');
            $description = isset($instance['description']) ? esc_attr($instance['description']) : '';
            ?>
            <p>
                <label for="title"><?php esc_html_e('Title:', 'dexterity'); ?></label>
                <input type="text" id="title" name="<?php echo esc_attr($this->get_field_name('title')); ?>" value="<?php echo esc_attr($title); ?>" class="widefat" />
            </p>
            <p>
                <label for="description"><?php esc_html_e('Description:', 'dexterity'); ?></label>

                <textarea id="description"  rows="8" cols="10" name="<?php echo esc_attr($this->get_field_name('description')); ?>" class="widefat"><?php echo force_balance_tags($description); ?></textarea>
                <span><?php esc_html_e('Shortcodes And HTML Tags are allowed.', 'dexterity'); ?></span>
            </p>

            <?php
        }

        /**
         * @Update NewsLetter
         *
         */
        public function update($new_instance, $old_instance) {
            $instance = $old_instance;
            $instance['title'] = (!empty($new_instance['title']) ) ? strip_tags($new_instance['title']) : 'NewsLetter';
            $instance['description'] = (!empty($new_instance['description']) ) ? strip_tags($new_instance['description']) : '';
            return $instance;
        }

        /**
         * @Display NewsLetter
         *
         *
         */
        public function widget($args, $instance) {
            extract($args);
            $counter = 0;
            $title = $instance['title'];
            $description = $instance['description'];
            $mailchimp = '';
            if (function_exists('fw_get_db_settings_option')) :
                $footer_text = fw_get_db_settings_option('mailchimp_title');
                $mailchimp = fw_get_db_settings_option('mailchimp_list');

            endif;

            $counter++;

            echo dexterity_esc_specialchars($args['before_widget']);

            if (!empty($title)) {
                echo dexterity_esc_specialchars($args['before_title'] . apply_filters('widget_title', esc_attr($title)) . $args['after_title']);
            }
            if (!empty($description)) {
                ?>
                <div class="tg-description"><?php echo force_balance_tags($description); ?></div>
            <?php } ?>
            <div id="newsletter_message_<?php echo intval($counter); ?>" class="mailchimp-error elm-display-none"><div class="mailchimp-message"></div></div>
            <form class="tg-newsletter-form" id="mailchimpwidget_<?php echo intval($counter); ?>">
                <fieldset>
                    <div class="form-group">
                        <input type="email" id="email" placeholder="<?php esc_html_e('Email', 'dexterity'); ?>" class="form-control" name="email">
                    </div>
                    <button class="subscribe_newsletter tg-btn" data-counter="<?php echo intval($counter); ?>"><?php esc_attr_e('subscribe', 'dexterity'); ?></button>

                </fieldset>
            </form>
            <script>
                jQuery(document).ready(function (e) {
                    jQuery(document).on('click', '.subscribe_newsletter', function (event) {
                        'use strict';
                        event.preventDefault();
                        $ = jQuery;
                        var $this = jQuery(this);
                        var counter = jQuery(this).data('counter');
                        $this.append("<i class='fa fa-refresh fa-spin'></i>");
                        jQuery('#newsletter_message_' + counter).hide();
                        jQuery('#newsletter_message_' + counter + " .mailchimp-message").removeClass('alert alert-success');
                        jQuery('#newsletter_message_' + counter + " .mailchimp-message").removeClass('alert alert-danger');

                        jQuery.ajax({
                            type: 'POST',
                            url: '<?php echo admin_url('admin-ajax.php'); ?>',
                            data: jQuery(this).parents('form').serialize() + '&action=subscribe_mailchimp',
                            dataType: "json",
                            success: function (response) {
                                 $this.find('i').remove();
                                if (response.type == 'success') {
                                    jQuery('#newsletter_message_' + counter + " .mailchimp-message").addClass('alert alert-success');
                                    jQuery('#mailchimpwidget_' + counter).get(0).reset();
                                    jQuery('#newsletter_message_' + counter).show();
                                    jQuery('#newsletter_message_' + counter + " .mailchimp-message").html(response.message);
                                    jQuery('#newsletter_' + counter).html('');

                                } else {
                                    jQuery('#newsletter_message_' + counter + " .mailchimp-message").addClass('alert alert-danger');
                                    jQuery('#newsletter_message_' + counter).show();
                                    jQuery('#newsletter_message_' + counter + " .mailchimp-message").html(response.message);
                                    jQuery('#newsletter_' + counter).html('');

                                }

                            }
                        });
                    });
                });

            </script>
            <?php
            echo dexterity_esc_specialchars($args['after_widget']);
        }

    }

}
add_action('widgets_init', create_function('', 'return register_widget("TG_NewsLetter");'));
