<?php
/**
 * The template part for displaying results in search pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Dexterity
 */
$section_width	 = 'col-lg-9 col-md-9 col-sm-12 col-xs-12';
?>

<div class="tg-main-content tg-haslayout page-archive-data">
	<div class="<?php echo esc_attr( $section_width );?> page-section">
    	<div class="tg-search-for">
            <div class="tg-heading-border">
                <h3><?php printf( esc_attr( 'Search Results for: %s', 'dexterity' ), '<span>' . get_search_query() . '</span>' ); ?></h3>
            </div><!-- .page-header -->
        </div>
		<div class="blog-grid blog-detail">
			<?php 
				
				global $paged;
				$tg_get_excerpt	= get_option('rss_use_excerpt');
				get_option('posts_per_page');
				
				if(!empty($_GET['s']) && have_posts()){
					if (empty($paged)) {
						$paged = 1;
					}
					 
					if (!isset($_GET["s"])) {
							$_GET["s"] = '';
					}
					
					while ( have_posts() ) : the_post(); 
						global $post;
						$width = '370';
						$height = '300';
						$title_limit = 1000;
						$thumbnail 	 = dexterity_prepare_thumbnail( $post->ID, $width, $height );
						$image_src = dexterity_prepare_thumbnail($post->ID, 'full');
						
						$stickyClass	= '';
						if( is_sticky() && !is_singular() ) {
							$stickyClass	= 'sticky';
						}
						
						$contentLength	= 'col-lg-12 col-md-12 col-sm-12 tg-verticalmiddle';
						$no_media	= empty(  $thumbnail ) ? 'no-image-list' : 'with-thumb';
				  ?>                         
				  <article class="tg-post no-gutters blog-list-view <?php echo esc_attr( $no_media.' '.$stickyClass );?>">
							<?php if (isset($thumbnail) && !empty($thumbnail)) {?>
                                <div class="col-lg-12 col-md-12 col-sm-12 tg-verticalmiddle figure-wrap">
                                    <figure>
                                        <img alt="<?php echo sanitize_title( get_the_title() ); ?>" src="<?php echo esc_url($thumbnail); ?>">
                                        <figcaption class="tg-img-hover">
                                            <div class="tg-box tg-displayblock">
                                                <ul class="tg-socialicons tg-large">
                                                    <li><a href="<?php echo esc_url(get_the_permalink()); ?>"><i class="fa fa-link"></i></a></li>
                                                </ul>
                                            </div>
                                        </figcaption>
                                    </figure>
                                </div>
                            <?php } ?>
                            <div class="col-lg-12 col-md-12 col-sm-12 tg-verticalmiddle">
                                <div class="tg-post-content">
                                    <div class="tg-heading-border">
                                        <h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>
                                    </div>
                                    <div class="tg-description">
                                        <p><?php dexterity_prepare_excerpt(255, 'false', ''); ?></p>
                                    </div>
                                    <ul class="tg-postmeta">
                                        <li><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php echo date_i18n('F d , Y', strtotime(get_the_date('Y-m-d',$post->ID))); ?></a></li>
                                        <?php echo get_the_term_list ( $post->ID, 'category', '<li> ' , ', ', '</li>' ); ?>
                                    </ul>
                                </div>
                                <?php
                                  if (is_sticky() && !is_singular()) :
                                  echo '<div class="sticky-post-wrap">
                                              <div class="sticky-txt">
                                               <em class="tg-featuretext">'.esc_html__('Featured','dexterity').'</em>
                                               <i class="fa fa-bolt"></i>
                                              </div>
                                         </div>';
                                  endif;
                                ?>
                            </div>
                        </article>
				  <?php 
				endwhile; 
				wp_reset_postdata();

				$qrystr = '';
				if ($wp_query->found_posts > get_option('posts_per_page')) {
				   if ( function_exists( 'dexterity_prepare_pagination' ) ) { 
						echo dexterity_prepare_pagination(wp_count_posts()->publish,get_option('posts_per_page'));
				   } 
				}
                   
			} else {
			?>
			<div class="search-none col-md-12">
				<p><?php  esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.','dexterity');?></p>
				<div class="tg-suggestions">
					<div class="tg-heading-border">
                    	<h4><?php  esc_html_e('Suggestions: ','dexterity');?> </h4>
                    </div>
					<ul>
						<li> <?php  esc_html_e('Make sure all words are spelled correctly ','dexterity');?> </li>
						<li> <?php  esc_html_e('Try more general keywords, especially if you are attempting a name ','dexterity');?> </li>
					</ul>
				</div>
				<form class="form-search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
					<div class="search-bar row">
						<div class="col-sm-6 col-xs-6 col-xs-offset-3">
							<div class="form-group">
								<input type="text" class="form-control" name="s" value="<?php echo get_search_query(); ?>" placeholder="<?php esc_attr_e('Type any keyword','dexterity');?>">
							</div>
							<div class="search-button">
								<button type="submit" class="tg-btn"><em><?php esc_html_e('search', 'dexterity'); ?></em></button>
							</div>
						</div> 
					</div>
				</form>
			</div>
			<?php } ?>
		</div>
	</div>
	<div class="col-lg-3 col-md-4 col-sm-4 col-xs-12 aside sidebar-section" id="sidebar">
		<aside id="tg-sidebar" class="tg-sidebar tg-haslayout">
			<?php get_sidebar();?>
		</aside>
	</div>
</div>