<?php
if (function_exists('fw_get_db_settings_option')) :
    $background = fw_get_db_settings_option('background');
    $comming_title = fw_get_db_settings_option('comming_title');
    $comming_subtitle = fw_get_db_settings_option('comming_subtitle');
    $comming_description = fw_get_db_settings_option('comming_description');
    $maintenance = fw_get_db_settings_option('maintenance');
    $date = fw_get_db_settings_option('date');
    $end = strtotime($date);
    $now = strtotime(date('Y-m-d H:i:s'));

endif;
$post_name = dexterity_get_post_name();

if ((isset($maintenance) && $maintenance == 'enable' and ! (is_user_logged_in()) ) || $post_name == "coming-soon") {
    $bg_image = '';
    $background_comingsoon = dexterity_comingsoon_background();
    if (isset($background_comingsoon) && !empty($background_comingsoon)) {
        $bg_image = 'style="background: url(' . $background_comingsoon . ') no-repeat 50% 50%;"';
    }
    ?>
    <div id="wrapper" class="tg-haslayout">
        <main id="main" class="tg-main-section tg-haslayout" <?php echo( $bg_image ); ?>>
            <div class="tg-commingsoon-content">
                <div class="tg-displaytable">
                    <div class="tg-displaytablecell">
                        <div class="tg-heading-border">
                            <?php if (isset($comming_title) && !empty($comming_title)) { ?>
                                <h2><?php echo esc_attr($comming_title); ?></h2>
                            <?php } ?>
                            <?php if (isset($comming_subtitle) && !empty($comming_subtitle)) { ?>
                                <h3><?php echo esc_attr($comming_subtitle); ?></h3>
                            <?php } ?>
                        </div>
                        <?php if (isset($comming_description) && !empty($comming_description)) { ?>
                            <p><?php echo do_shortcode($comming_description); ?></p>
                        <?php } ?>
                        <div class="tg-countdown tg-haslayout">
                            <div class="tg-clock">
                                <div class="clock-item clock-days countdown-time-value">
                                    <div id="canvas-days" class="clock-canvas"></div>
                                    <div class="text">
                                        <p class="type-days type-time"><?php esc_html_e('DAYS', 'dexterity'); ?></p>
                                        <p class="val">0</p>
                                    </div>
                                </div>
                                <div class="clock-item clock-hours countdown-time-value">
                                    <div id="canvas-hours" class="clock-canvas"></div>
                                    <div class="text">
                                        <p class="type-hours type-time"><?php esc_html_e('HOURS', 'dexterity'); ?></p>
                                        <p class="val">0</p>
                                    </div>
                                </div>
                                <div class="clock-item clock-minutes countdown-time-value">
                                    <div id="canvas-minutes" class="clock-canvas"></div>
                                    <div class="text">
                                        <p class="type-minutes type-time"><?php esc_html_e('MINUTES', 'dexterity'); ?></p>
                                        <p class="val">0</p>
                                    </div>
                                </div>
                                <div class="clock-item clock-seconds countdown-time-value">
                                    <div id="canvas-seconds" class="clock-canvas"></div>
                                    <div class="text">
                                        <p class="type-seconds type-time"><?php esc_html_e('SECONDS', 'dexterity'); ?></p>
                                        <p class="val">0</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script>
                jQuery(document).ready(function (e) {
                    jQuery('.tg-countdown').final_countdown({
                        'start': undefined,
                        'end': <?php echo esc_js($end); ?>,
                        'now': <?php echo esc_js($now); ?>,
                    });
                });
            </script>
        </main>
    </div>
    <?php
    die();
}
