<?php
/**
 * Addresses should be in human readable format as a single IP (e.g. 1.2.3.4) or CIDR (e.g. 1.2.3.4/32)
 */
$wfIPWhitelist = array(
	'private' => array(
		//We've modified this and removed some addresses which may be routable on the Net and cause auto-whitelisting.
		//'0.0.0.0/8',			#Broadcast addr
		'10.0.0.0/8',			#Private addrs
		//'100.64.0.0/10',		#carrier-grade-nat for comms between ISP and subscribers
		'127.0.0.0/8',			#loopback
		//'169.254.0.0/16',		#link-local when DHCP fails e.g. os x
		'172.16.0.0/12',		#private addrs
		'192.0.0.0/29',			#used for NAT with IPv6, so basically a private addr
		//'192.0.2.0/24',		#Only for use in docs and examples, not for public use
		//'192.88.99.0/24',		#Used by 6to4 anycast relays
		'192.168.0.0/16',		#Used for local communications within a private network
		//'198.18.0.0/15',		#Used for testing of inter-network communications between two separate subnets
		//'198.51.100.0/24',	#Assigned as "TEST-NET-2" in RFC 5737 for use solely in documentation and example source code and should not be used publicly.
		//'203.0.113.0/24',		#Assigned as "TEST-NET-3" in RFC 5737 for use solely in documentation and example source code and should not be used publicly.
		//'224.0.0.0/4',		#Reserved for multicast assignments as specified in RFC 5771
		//'240.0.0.0/4',		#Reserved for future use, as specified by RFC 6890
		//'255.255.255.255/32',	#Reserved for the "limited broadcast" destination address, as specified by RFC 6890
	),
	'wordfence' => array(
		// 69.46.36.1 - 69.46.36.32
		'69.46.36.1/32',
		'69.46.36.2/31',
		'69.46.36.4/30',
		'69.46.36.8/29',
		'69.46.36.16/28',
		'69.46.36.32/32',
	),
	'sucuri' => array(
		'97.74.127.171',
		'69.164.203.172',
		'173.230.128.135',
		'66.228.34.49',
		'66.228.40.185',
		'50.116.36.92',
		'50.116.36.93',
		'50.116.3.171',
		'198.58.96.212',
		'50.116.63.221',
		'192.155.92.112',
		'192.81.128.31',
		'198.58.106.244',
		'192.155.95.139',
		'23.239.9.227',
		'198.58.112.103',
		'192.155.94.43',
		'162.216.16.33',
		'173.255.233.124',
		'173.255.233.124',
		'192.155.90.179',
		'50.116.41.217',
		'192.81.129.227',
		'198.58.111.80',
		'162.216.19.183',
	),
	'facebook' => array(
		'204.15.20.0/22',
		'69.63.176.0/20',
		'66.220.144.0/20',
		'66.220.144.0/21',
		'69.63.184.0/21',
		'69.63.176.0/21',
		'74.119.76.0/22',
		'69.171.255.0/24',
		'173.252.64.0/18',
		'69.171.224.0/19',
		'69.171.224.0/20',
		'103.4.96.0/22',
		'69.63.176.0/24',
		'173.252.64.0/19',
		'173.252.70.0/24',
		'31.13.64.0/18',
		'31.13.24.0/21',
		'66.220.152.0/21',
		'66.220.159.0/24',
		'69.171.239.0/24',
		'69.171.240.0/20',
		'31.13.64.0/19',
		'31.13.64.0/24',
		'31.13.65.0/24',
		'31.13.67.0/24',
		'31.13.68.0/24',
		'31.13.69.0/24',
		'31.13.70.0/24',
		'31.13.71.0/24',
		'31.13.72.0/24',
		'31.13.73.0/24',
		'31.13.74.0/24',
		'31.13.75.0/24',
		'31.13.76.0/24',
		'31.13.77.0/24',
		'31.13.96.0/19',
		'31.13.66.0/24',
		'173.252.96.0/19',
		'69.63.178.0/24',
		'31.13.78.0/24',
		'31.13.79.0/24',
		'31.13.80.0/24',
		'31.13.82.0/24',
		'31.13.83.0/24',
		'31.13.84.0/24',
		'31.13.85.0/24',
		'31.13.86.0/24',
		'31.13.87.0/24',
		'31.13.88.0/24',
		'31.13.89.0/24',
		'31.13.90.0/24',
		'31.13.91.0/24',
		'31.13.92.0/24',
		'31.13.93.0/24',
		'31.13.94.0/24',
		'31.13.95.0/24',
		'69.171.253.0/24',
		'69.63.186.0/24',
		'31.13.81.0/24',
		'179.60.192.0/22',
		'179.60.192.0/24',
		'179.60.193.0/24',
		'179.60.194.0/24',
		'179.60.195.0/24',
		'185.60.216.0/22',
		'45.64.40.0/22',
		'185.60.216.0/24',
		'185.60.217.0/24',
		'185.60.218.0/24',
		'185.60.219.0/24',
		'129.134.0.0/16',
		'157.240.0.0/16',
		'204.15.20.0/22',
		'69.63.176.0/20',
		'69.63.176.0/21',
		'69.63.184.0/21',
		'66.220.144.0/20',
		'69.63.176.0/20',
		'2620:0:1c00::/40',
		'2a03:2880::/32',
		'2a03:2880:fffe::/48',
		'2a03:2880:ffff::/48',
		'2620:0:1cff::/48',
		'2a03:2880:f000::/48',
		'2a03:2880:f001::/48',
		'2a03:2880:f002::/48',
		'2a03:2880:f003::/48',
		'2a03:2880:f004::/48',
		'2a03:2880:f005::/48',
		'2a03:2880:f006::/48',
		'2a03:2880:f007::/48',
		'2a03:2880:f008::/48',
		'2a03:2880:f009::/48',
		'2a03:2880:f00a::/48',
		'2a03:2880:f00b::/48',
		'2a03:2880:f00c::/48',
		'2a03:2880:f00d::/48',
		'2a03:2880:f00e::/48',
		'2a03:2880:f00f::/48',
		'2a03:2880:f010::/48',
		'2a03:2880:f011::/48',
		'2a03:2880:f012::/48',
		'2a03:2880:f013::/48',
		'2a03:2880:f014::/48',
		'2a03:2880:f015::/48',
		'2a03:2880:f016::/48',
		'2a03:2880:f017::/48',
		'2a03:2880:f018::/48',
		'2a03:2880:f019::/48',
		'2a03:2880:f01a::/48',
		'2a03:2880:f01b::/48',
		'2a03:2880:f01c::/48',
		'2a03:2880:f01d::/48',
		'2a03:2880:f01e::/48',
		'2a03:2880:f01f::/48',
		'2a03:2880:1000::/36',
		'2a03:2880:2000::/36',
		'2a03:2880:3000::/36',
		'2a03:2880:4000::/36',
		'2a03:2880:5000::/36',
		'2a03:2880:6000::/36',
		'2a03:2880:7000::/36',
		'2a03:2880:f020::/48',
		'2a03:2880:f021::/48',
		'2a03:2880:f022::/48',
		'2a03:2880:f023::/48',
		'2a03:2880:f024::/48',
		'2a03:2880:f025::/48',
		'2a03:2880:f026::/48',
		'2a03:2880:f027::/48',
		'2a03:2880:f028::/48',
		'2a03:2880:f029::/48',
		'2a03:2880:f02a::/48',
		'2a03:2880:f02b::/48',
		'2a03:2880:f02c::/48',
		'2a03:2880:f02d::/48',
		'2a03:2880:f02e::/48',
		'2a03:2880:f02f::/48',
		'2a03:2880:f030::/48',
		'2a03:2880:f031::/48',
		'2a03:2880:f032::/48',
		'2a03:2880:f033::/48',
		'2a03:2880:f034::/48',
		'2a03:2880:f035::/48',
		'2a03:2880:f036::/48',
		'2a03:2880:f037::/48',
		'2a03:2880:f038::/48',
		'2a03:2880:f039::/48',
		'2a03:2880:f03a::/48',
		'2a03:2880:f03b::/48',
		'2a03:2880:f03c::/48',
		'2a03:2880:f03d::/48',
		'2a03:2880:f03e::/48',
		'2a03:2880:f03f::/48',
		'2401:db00::/32',
		'2a03:2880::/36',
		'2803:6080::/32',
	),
);