## Description ##

> WordPress Landing Pages works as a standalone plugin or hand in hand with [WordPress Calls to Action](http://wordpress.org/plugins/cta/ "Learn more about Calls to Action") & [WordPress Leads](http://wordpress.org/plugins/leads/ "Learn more about WordPress Leads") to create a powerful & free lead generation system for your business.

This plugin creates landing pages (a.k.a. conversion or splash pages) for your WordPress site. It gives site owners the ability to monitor and track conversion rates, run a/b or multivariate split tests on landing pages, and most importantly increase lead flow!

The landing page plugin was specifically designed with inbound marketing best practices in mind and will help you drive & convert more leads on your site.

Landing pages are an ideal way to convert more of your passive website visitors into active leads or email list subscribers.

### Highlights ###

* Create beautiful Landing Pages on your WordPress site.
* Visual Editor to view changes being made on the fly!
* Track conversion rates on your landing pages for continual optimization.
* Easily clone existing landing pages and run A/B Split tests on variations.
* Use your current WordPress theme or choose from our library of custom landing page designs.
* Pre-populate Forms with visitor information to increase conversion rates
* Gather lead intelligence and track lead activity with <a href="http://wordpress.org/plugins/leads/screenshots/">WordPress Leads</a>
* Extend functionality with our growing repository of <a href="http://www.inboundnow.com/market/category/landing-pages/extensions/">third party add ons</a>.
* Easily implement your own custom landing page design.

This plugin is form agnostic meaning it will work with any form system you use.

Recommended form plugins (Gravity forms, Ninja Forms or Contact form 7)

### About the Plugin ###

http://www.youtube.com/watch?v=flEd0sRTFUo

### Developers & Designers ###

We built the landing page plugin as a framework! Need A/B testing out of the box implemented for your existing designs? Use WordPress Landing Pages to quickly spin up new landing pages that have all the functionality your clients will need.

You can quickly take your existing designs and implement them using our <a href="http://docs.inboundnow.com/section/developer/">templating framework</a>.

The plugin is also fully extendable and has a number of actions, filters, and hooks available for use. If a hook doesn't exist, simply ask and we can implement custom changes.


[Follow Development on GitHub ](https://github.com/inboundnow/landing-pages "Follow & Contribute to core development on GitHub")
 |
[Follow Development on Twitter ](https://twitter.com/gitlandingpages "See our latest development commits on Twitter")


## Installation ##

1. Upload `landing-pages` folder to the `/wp-content/plugins/` directory
1. Activate the plugin through the 'Plugins' menu in WordPress

## Frequently Asked Questions ##
*Can I create my own landing page designs?,
*Yes! You can learn how to <a href="http://docs.inboundnow.com/guide/creating-landing-page-templates/">create your own landing page template here</a>.

