/*
* For future use when cookies are stored as json objects
usage: <form id="my-form">
    <input type="text" name="name" />
    <input type="email" name="email" />

    <input type="text" name="address[addr1]" />
    <input type="text" name="address[city]" />
    <input type="text" name="address[state]" />
</form>

// your JSON object
// keys have to match input names
var data = {
    "email": "john@doe.com",
    "name": "John Doe",
    "address": {
        "addr1": "Street name",
        "city": "City name",
        "state": "State"
    }
}

// your containing element
var formElement = document.getElementById('my-form');

// populate the form with our JSON object
populateFields(formElement, data);
function populateFields(container, data, basename) {

    for(var key in data) {

        var name = key;
        var value = data[key];

        // no need to set empty values
        if(value == "") {
            continue;
        }

        // handle array name attributes
        if(typeof(basename) !== "undefined") {
            name = basename + "[" + key + "]";
        }

        if(value.constructor == Array) {
            name += '[]';
        } else if(typeof value == "object") {
            populateFields(container, value, name);
            continue;
        }

        // populate field
        var elements = container.querySelectorAll('input[name="'+ name +'"], select[name="'+ name +'"], textarea[name="'+ name +'"]');

        // Dirty: abandon if we did not find the element
        if(!elements) {
            return;
        }

        // loop through found elements to set their values
        for(var i = 0; i < elements.length; i++) {

            var element = elements[i];

            // check element type
            switch(element.type || element.tagName) {
                case 'text':
                case 'email':
                case 'date':
                case 'tel':
                    element.value = value;
                    break;

                case 'radio':
                    element.checked = (element.value === value);
                    break;

                case 'checkbox':
                    for(var j = 0; j < value.length; j++) {
                        element.checked = (element.value === value[j]);
                    }
                    break;

                case 'select-multiple':
                    var values = value.constructor == Array ? value : [value];

                    for(var k = 0; k < element.options.length; k++)
                    {
                        for(var l = 0; l < values.length; l++)
                        {
                            element.options[k].selected |= (element.options[k].value == values[l]);
                        }
                    }
                    break;

                case 'select':
                case 'select-one':
                    element.value = value.toString() || value;
                    break;
            }
        }


    }

}*/


function rememberThemAll() {
	var elements = document.querySelectorAll('input, select, textarea'),
	utils = _inbound.Utils;

	for (var i = elements.length - 1; i >= 0; i--) {
		/* polyfill this dom load */
        var name = ( elements[i].name ) ? elements[i].name : '';
		var type = ( elements[i].type ) ? elements[i].type : 'text';
		if(type === 'submit' || type === 'hidden' || type === 'checkbox' || type === 'file' || type === "password") {
			continue;
		}

	    if(utils.readCookie(name) && name != 'comment' ){
	        //jQuery(this).val( jQuery.cookie(name) );
	       value = decodeURIComponent(utils.readCookie(name));
	       elements[i].value = value;
	    }

	    utils.addListener(elements[i], 'change', function(e) {
	    	console.log('change ' + e.target.name  + " " + encodeURIComponent(e.target.value));
	    	/* TODO Fix the correct Value */
	    	var fieldname = e.target.name.replace(/-/g, "_");

	    	utils.createCookie(e.target.name, encodeURIComponent(e.target.value));
	    	// var FormStore = _inbound.totalStorage('the_key');
	    	// update formStore Obj and resave
	    	// _inbound.totalStorage('the_key', FormStore);
	    	/* Push to 'unsubmitted form object' */
	    });

	};

}

/* Dom ready  */
jQuery(document).ready(function($) {

	//rememberThemAll();

});