<?php

///////////////////////////////////////////

//--------- OT THEME OPTIONS ---------------//

///////////////////////////////////////////



// Optional OT params

add_filter( 'ot_show_pages', '__return_false' );

add_filter( 'ot_show_new_layout', '__return_false' );

add_filter( 'ot_theme_mode', '__return_true' );

include_once( 'option-tree/ot-loader.php' );



// BOC Theme Options

include_once( 'includes/theme-options.php' );



///////////////////////////////////////////

//--------- OT THEME OPTIONS :: END --------//

///////////////////////////////////////////





// Aqua Customizer Theme Options

include_once( 'includes/customizer_theme-options.php' );

include_once( 'includes/meta_boxes.php' );



// Default RSS feed links

add_theme_support('automatic-feed-links');



// Sets up the content width value based on the theme's design and stylesheet.

if ( ! isset( $content_width ) )

	$content_width = 940;



// Post Formats

add_theme_support( 'post-formats',  array( 'gallery','video' ));

add_post_type_support( 'post', 'post-formats' );

add_post_type_support( 'portfolio', 'post-formats' );





// Enable Background Support

$args = array(

    'default-color' => 'f6f6f6',

    'default-image' => get_template_directory_uri() . '/images/main_bgr.png',

);

add_theme_support( 'custom-background', $args );



// Aqua Customizer Theme Options

add_action( 'customize_register', 'aqua_customize_register' );



// Add customize Menu Item

add_action ('admin_menu', 'customizetheme_admin');

function customizetheme_admin() {

    add_theme_page( 'Customize', 'Customize', 'edit_theme_options', 'customize.php' ); 

}



// Register Navigation

add_theme_support('menus');

register_nav_menu('main_navigation', 'Main Navigation');





// Custom functions + Widgets

require_once( 'includes/boc_custom.php' );

require_once( 'includes/boc_widgets.php' );



add_action('widgets_init', 'boc_load_widgets');





// Make theme available for translation

load_theme_textdomain( 'Aqua', get_template_directory() . '/languages' );







// Images



add_theme_support('post-thumbnails');



set_post_thumbnail_size(640, 300, true); //size of thumbs

add_image_size('small-thumb', 60, 60, true);  

add_image_size('portfolio-main', 700, 340, true);

add_image_size('portfolio-medium', 460, 290, true);

add_image_size('portfolio-thumb', 300, 180, true);

add_image_size('portfolio-full', 940, 600, true);









// Register widgetized locations

if(function_exists('register_sidebar')) {

	register_sidebar(array(

		'name' => 'Aqua Sidebar',

		'before_widget' => '<div id="%1$s" class="widget %2$s">',

		'after_widget' => '</div>',

		'before_title' => '<h4 class="title"><span>',

		'after_title' => '</span></h4>',

	));



	register_sidebar(array(

		'name' => 'Footer Widget 1',

		'before_widget' => '',

		'after_widget' => '',

		'before_title' => '<h3>',

		'after_title' => '</h3>',

	));



	register_sidebar(array(

		'name' => 'Footer Widget 2',

		'before_widget' => '',

		'after_widget' => '',

		'before_title' => '<h3>',

		'after_title' => '</h3>',

	));



	register_sidebar(array(

		'name' => 'Footer Widget 3',

		'before_widget' => '',

		'after_widget' => '',

		'before_title' => '<h3>',

		'after_title' => '</h3>',

	));



	register_sidebar(array(

		'name' => 'Footer Widget 4',

		'before_widget' => '',

		'after_widget' => '',

		'before_title' => '<h3>',

		'after_title' => '</h3>',

	));

	

	register_sidebar(array(

		'name' => 'Aqua Contact Sidebar',

		'before_widget' => '<div id="%1$s" class="widget %2$s">',

		'after_widget' => '</div>',

		'before_title' => '<h4 class="title"><span>',

		'after_title' => '</span></h4>',

	));		

	

}

// Register Dynamic Widgets (OT)

if (ot_get_option('boc_sidebars')){

    $dynamic_sidebars = ot_get_option('boc_sidebars');

    foreach ($dynamic_sidebars as $dynamic_sidebar) {

	    register_sidebar(array(

	        'name' => $dynamic_sidebar["title"],

	        'id' => $dynamic_sidebar["id"],

	        'before_widget' => '<div id="%1$s" class="widget %2$s">',

	        'after_widget' => '</div>',

	        'before_title' => '<h4 class="title"><span>',

	        'after_title' => '</span></h4>',

	        ));

	}

}







// Register custom post types

add_action('init', 'boc_custom_types');

function boc_custom_types() {

	register_post_type(

		'portfolio',

		array(

			'labels' => array(

				'name' => 'Portfolio',

				'singular_name' => 'Portfolio'

			),

			'public' => true,

			'has_archive' => true,

			'rewrite' => array('slug' => 'portfolio_item'),

			'supports' => array('title', 'editor', 'thumbnail'),

			'can_export' => true,

			'show_in_nav_menus' => true,

		)

	);



	register_post_type(

		'services',

		array(

			'labels' => array(

				'name' => 'Services',

				'singular_name' => 'Services'

			),

			'public' => true,

			'has_archive' => true,

			'rewrite' => array('slug' => 'services_item'),

			'supports' => array('title', 'editor', 'thumbnail','page-attributes'),

			'can_export' => true,

			'show_in_nav_menus' => true,

		)

	);



	register_taxonomy('portfolio_category', 'portfolio', array('hierarchical' => true, 'label' => 'Portfolio Categories', 'query_var' => true, 'rewrite' => true));

}



/*

function my_rewrite_flush() {

    flush_rewrite_rules();

}

add_action( 'after_switch_theme', 'my_rewrite_flush' );

*/



/**

 * add a default-gravatar to options

 */

if ( !function_exists('fb_addgravatar') ) {

	function fb_addgravatar( $avatar_defaults ) {

		$myavatar = get_template_directory_uri() . '/images/comment_avatar.png';

		$avatar_defaults[$myavatar] = 'people';

		return $avatar_defaults;

	}

	add_filter( 'avatar_defaults', 'fb_addgravatar' );

}





// BOC Shortcodes

include_once( 'includes/shortcodes.php' );

add_action('init', 'boc_add_buttons');



// Use shortcodes in Widgets

add_filter('widget_text', 'do_shortcode');





// Customize Tag Cloud

function my_tag_cloud_args($in){

    return 'smallest=13&largest=13&number=25&orderby=name&unit=px';

}

add_filter( 'widget_tag_cloud_args', 'my_tag_cloud_args');





// Customize Items per page for Portfolio Taxonomy

$option_posts_per_page = get_option( 'posts_per_page' );

add_action( 'init', 'my_modify_posts_per_page', 0);

function my_modify_posts_per_page() {

    add_filter( 'option_posts_per_page', 'my_option_posts_per_page' );

}

function my_option_posts_per_page( $value ) {

    global $option_posts_per_page;

    if ( is_tax( 'portfolio_category') ) {

        return (ot_get_option('portfolio_items_per_page',9) ? ot_get_option('portfolio_items_per_page',9) : 9);

    } else {

        return $option_posts_per_page;

    }

}

add_shortcode('rhino-chart', 'rhino_chart');
function rhino_chart(){
	$returnText = "
	<style>
        #rhinoTable{position:relative;width:100%;margin:50px auto;font-family:Verdana, Geneva, sans-serif;font-size:12px;line-height:2em;color:#4d4d4d;}
        #rhinoTable table{background:#e6e6e6;border-spacing:1px;width:100%;border-collapse:separate;}
        #rhinoTable tr:nth-child(odd){background:#fcfeff;}
        #rhinoTable tr:nth-child(even){background:#f3f5f5;}
        #rhinoTable td{width:9%;position:relative;}
        #rhinoTable td:first-child{padding-left:1em;}
        #rhinoTable td:first-child, td:nth-child(2){width:14%;}
        #rhinoTable td:not(:first-child){text-align:center;}
        #rhinoTable td:nth-child(2){background:#fdfaef;font-size:1.2em;font-weight:bold;}
        #rhinoTable td:nth-child(1):before{content:'';display:block;position:absolute;left:0;right:0;top:-1px;bottom:0;opacity:.3;
        background: -moz-linear-gradient(left,  rgba(0,0,0,0.01) 0%, rgba(0,0,0,0.01) 92%, rgba(0,0,0,0.44) 100%); /* FF3.6+ */
        background: -webkit-gradient(linear, left top, right top, color-stop(0%,rgba(0,0,0,0.01)), color-stop(92%,rgba(0,0,0,0.01)), color-stop(100%,rgba(0,0,0,0.44))); /* Chrome,Safari4+ */
        background: -webkit-linear-gradient(left,  rgba(0,0,0,0.01) 0%,rgba(0,0,0,0.01) 92%,rgba(0,0,0,0.44) 100%); /* Chrome10+,Safari5.1+ */
        background: -o-linear-gradient(left,  rgba(0,0,0,0.01) 0%,rgba(0,0,0,0.01) 92%,rgba(0,0,0,0.44) 100%); /* Opera 11.10+ */
        background: -ms-linear-gradient(left,  rgba(0,0,0,0.01) 0%,rgba(0,0,0,0.01) 92%,rgba(0,0,0,0.44) 100%); /* IE10+ */
        background: linear-gradient(to right,  rgba(0,0,0,0.01) 0%,rgba(0,0,0,0.01) 92%,rgba(0,0,0,0.44) 100%); /* W3C */
        filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#03000000', endColorstr='#70000000',GradientType=1 ); /* IE6-9 */
    }
        #rhinoTable td:nth-child(3):before{content:'';display:block;position:absolute;left:0;right:0;top:-1px;bottom:0;opacity:.3;
        background: -moz-linear-gradient(left,  rgba(0,0,0,0.44) 0%, rgba(0,0,0,0.01) 8%, rgba(0,0,0,0.01) 100%); /* FF3.6+ */
        background: -webkit-gradient(linear, left top, right top, color-stop(0%,rgba(0,0,0,0.44)), color-stop(8%,rgba(0,0,0,0.01)), color-stop(100%,rgba(0,0,0,0.01))); /* Chrome,Safari4+ */
        background: -webkit-linear-gradient(left,  rgba(0,0,0,0.44) 0%,rgba(0,0,0,0.01) 8%,rgba(0,0,0,0.01) 100%); /* Chrome10+,Safari5.1+ */
        background: -o-linear-gradient(left,  rgba(0,0,0,0.44) 0%,rgba(0,0,0,0.01) 8%,rgba(0,0,0,0.01) 100%); /* Opera 11.10+ */
        background: -ms-linear-gradient(left,  rgba(0,0,0,0.44) 0%,rgba(0,0,0,0.01) 8%,rgba(0,0,0,0.01) 100%); /* IE10+ */
        background: linear-gradient(to right,  rgba(0,0,0,0.44) 0%,rgba(0,0,0,0.01) 8%,rgba(0,0,0,0.01) 100%); /* W3C */
        filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#70000000', endColorstr='#03000000',GradientType=1 ); /* IE6-9 */
    
    }
        #rhinoTable tr:nth-child(even) td:nth-child(2){background:#f3f1e6;}
        
        
        #rhinoTable table:first-child{background:none;}
        #rhinoTable table:first-child tr{background:none;height:105px;}
        #rhinoTable table:first-child td:nth-child(2){background:none;}
        #rhinoTable table:first-child td:nth-child(1):before, #rhinoTable table:first-child td:nth-child(3):before{display:none;}
        #rhinoTable table:first-child td:nth-child(2):after{display:block;content:'';left:-17%;right:-17%;top:0;bottom:0;position:absolute;background:url(/images2/rhino.png) no-repeat center bottom;background-size:contain;}
        #rhinoTable table:first-child td:nth-child(3){background:url(/images2/keypoint.png) no-repeat center center;background-size:contain;}
        #rhinoTable table:first-child td:nth-child(4){background:url(/images2/rpm.png) no-repeat center center;background-size:contain;}
        #rhinoTable table:first-child td:nth-child(5){background:url(/images2/pmi.png) no-repeat center center;background-size:contain;}
        #rhinoTable table:first-child td:nth-child(6){background:url(/images2/fre.png) no-repeat center center;background-size:contain;}
        #rhinoTable table:first-child td:nth-child(7){background:url(/images2/rems.png) no-repeat center center;background-size:contain;}
        #rhinoTable table:first-child td:nth-child(8){background:url(/images2/northpoint.png) no-repeat center center;background-size:contain;}
        #rhinoTable table:first-child td:nth-child(9){background:url(/images2/premier.png) no-repeat center center;background-size:contain;}
        #rhinoTable table:first-child td:nth-child(10){background:url(/images2/strategic.png) no-repeat center center;background-size:contain;}
        
        
        #rhinoTable table:nth-child(3){background:none;font-size:1.2em;}
        #rhinoTable table:nth-child(3) tr{background:none;}
        #rhinoTable table:nth-child(3) td:nth-child(1):before, #rhinoTable table:nth-child(3) td:nth-child(3):before{display:none;}
        #rhinoTable table:nth-child(3) td:nth-child(2){background:#033558;color:#fff;}
        
        #rhinoTable .input-fields{position: absolute;top: 1em;right: 1em;text-align:right;}
        #rhinoTable .input-fields label{display:inline-block;font-size:1em;}
        #rhinoTable .input-fields input{display:inline-block;width:9%;font-size:1em;line-height:2em;padding:0 1em;}
    </style>
		<h3>Price Calculator</h3>
        <div id='rhinoTable'>
            <table>
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
            </table>
            <table>
                <tr>
                    <td>Fees</td>
                    <td>Rhino PM</td>
                    <td>Keyrenter</td>
                    <td>Real PM</td>
                    <td>PMI</td>
                    <td>FRE</td>
                    <td>REMS</td>
                    <td>NorthPoint</td>
                    <td>Premier</td>
                    <td>Strategic</td>
                </tr>
                <tr>
                    <td>Set Up</td>
                    <td></td>
                    <td>$99</td>
                    <td>$295</td>
                    <td></td>
                    <td></td>
                    <td>$75</td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td>Marketing</td>
                    <td></td>
                    <td>$99</td>
                    <td></td>
                    <td></td>
                    <td>$299</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td>Leasing Fee</td>
                    <td></td>
                    <td>2%</td>
                    <td></td>
                    <td></td>
                    <td>50%</td>
                    <td></td>
                    <td>$350</td>
                    <td>25%</td>
                    <td></td>
                </tr>
                <tr>
                    <td>Monthly Fee</td>
                    <td>$75</td>
                    <td>$75</td>
                    <td>10%</td>
                    <td>10%</td>
                    <td>8%</td>
                    <td>8.5%</td>
                    <td>8%</td>
                    <td>8%</td>
                    <td>10%</td>
                </tr>
                <tr>
                    <td>Renewal Fee</td>
                    <td></td>
                    <td>$99</td>
                    <td>$150</td>
                    <td>$125</td>
                    <td>$149</td>
                    <td></td>
                    <td>$100</td>
                    <td>$100</td>
                    <td></td>
                </tr>
                <tr>
                    <td>Maint. Mark Up</td>
                    <td></td>
                    <td>10%</td>
                    <td>10%</td>
                    <td>10%</td>
                    <td></td>
                    <td>10%</td>
                    <td>10%</td>
                    <td>10%</td>
                    <td></td>
                </tr>
            </table>
            <table>
                <tr>
                    <td>Annual Cost</td>
                    <td id='rhino-annual'></td>
                    <td id='keyRent-annual'></td>
                    <td id='real-annual'></td>
                    <td id='pmi-annual'></td>
                    <td id='fre-annual'></td>
                    <td id='rems-annual'></td>
                    <td id='northPoint-annual'></td>
                    <td id='premier-annual'></td>
                    <td id='strategic-annual'></td>
                </tr>
            </table>
            <div class='input-fields'>
                <label>Estimated Rent: </label><input type='text' id='estimated-rent' />
                <label>Number of Units: </label><input type='text' id='number-of-units' />
				<input type='submit' value='Submit' />
            </div>
        </div>	
        
        
        <script>
        jQuery(document).ready(function($){	
        
        
        $(window).resize(function(){
            newWidth = $('#rhinoTable').width();
            $('#rhinoTable table:first-child tr').css('height', newWidth*0.11+'px');
            $('#rhinoTable').css('font-size', newWidth*0.012+'px');
            
        });
		$(window).resize();
        
        
        $('#estimated-rent, #number-of-units').on('blur', function(){
            $('#rhinoTable table:nth-child(3) td:not(:first-child)').stop().animate({opacity: '0'}, 600, function(){
                estimatedRent = $('#estimated-rent').val();
                numUnits = $('#number-of-units').val();
                calculate_total(estimatedRent, numUnits);
            });
            
            $('#rhinoTable table:nth-child(3) td:not(:first-child)').animate({opacity: '1'}, 600);
        });
		$('#rhinoTable .input-fields input[type=\'submit\']').click(function(){
            $('#rhinoTable table:nth-child(3) td:not(:first-child)').stop().animate({opacity: '0'}, 600, function(){
                estimatedRent = $('#estimated-rent').val();
                numUnits = $('#number-of-units').val();
                calculate_total(estimatedRent, numUnits);
            });
            
            $('#rhinoTable table:nth-child(3) td:not(:first-child)').animate({opacity: '1'}, 600);
		});
        
        $('#estimated-rent').val('1300');
        $('#number-of-units').val('1');
        $('#number-of-units').blur();
        
        function calculate_total(estimatedRent, numUnits){
            
            numMonths = 12;
            
            // Calculate Rhino PM Cost
            rhinoFee = (numUnits > 1) ? 65 : 75;
            rhinoAnnual = rhinoFee * numUnits * numMonths;
            $('#rhino-annual').text(commaSeparateNumber(rhinoAnnual));
            
            // Calculate Keyrenter Cost
            keyRentSetup = 99;
            keyRentMarketing = 99;
            keyRentLeasing = .02 * estimatedRent;
            keyRentMonthly = 75;
            keyRentRenewal = 99;
            keyRentMaint = .1; //Percentage
            keyRentInspection = 100;
            keyRentAnnual = (keyRentSetup+keyRentMarketing+keyRentLeasing+(keyRentMonthly*numMonths)+keyRentRenewal+keyRentInspection)*numUnits;
            $('#keyRent-annual').text(commaSeparateNumber(keyRentAnnual));
            
            // Calculate Real PM Cost
            realSetup = 295;
            realMarketing = 0;
            realLeasing = 0;
            realMonthly = .1 * estimatedRent;
            realRenewal = 150;
            realMaint = .1; //Percentage
            realInspection = 0;
            realAnnual = (realSetup+realMarketing+realLeasing+(realMonthly*numMonths)+realRenewal+realInspection)*numUnits;
            $('#real-annual').text(commaSeparateNumber(realAnnual));
            
            // Calculate PMI Cost
            pmiSetup = 0;
            pmiMarketing = 0;
            pmiLeasing = 0;
            pmiMonthly = .1 * estimatedRent;
            pmiRenewal = 125;
            pmiMaint = .1; //Percentage
            pmiInspection = 70;
            pmiAnnual = (pmiSetup+pmiMarketing+pmiLeasing+(pmiMonthly*numMonths)+pmiRenewal+pmiInspection)*numUnits;
            $('#pmi-annual').text(commaSeparateNumber(pmiAnnual));
            
            // Calculate FRE Cost
            freSetup = 0;
            freMarketing = 299;
            freLeasing = .5 * estimatedRent;
            freMonthly = .08 * estimatedRent;
            freRenewal = 149;
            freMaint = 0; //Percentage
            freInspection = 0;
            freAnnual = (freSetup+freMarketing+freLeasing+(freMonthly*numMonths)+freRenewal+freInspection)*numUnits;
            $('#fre-annual').text(commaSeparateNumber(freAnnual));
            
            // Calculate REMS Cost
            remsSetup = 75;
            remsMarketing = 0;
            remsLeasing = 0;
            remsMonthly = .085 * estimatedRent;
            remsRenewal = 0;
            remsMaint = .1; //Percentage
            remsInspection = 0;
            remsAnnual = (remsSetup+remsMarketing+remsLeasing+(remsMonthly*numMonths)+remsRenewal+remsInspection)*numUnits;
            $('#rems-annual').text(commaSeparateNumber(remsAnnual));
            
            // Calculate North Point Cost
            northPointSetup = 0;
            northPointMarketing = 0;
            northPointLeasing = 350;
            northPointMonthly = .08 * estimatedRent;
            northPointRenewal = 100;
            northPointMaint = .1; //Percentage
            northPointInspection = 0;
            northPointAnnual = (northPointSetup+northPointMarketing+northPointLeasing+(northPointMonthly*numMonths)+northPointRenewal+northPointInspection)*numUnits;
            $('#northPoint-annual').text(commaSeparateNumber(northPointAnnual));
            
            // Calculate Premier Cost
            premierSetup = 0;
            premierMarketing = 0;
            premierLeasing = .25 * estimatedRent;
            premierMonthly = .08 * estimatedRent;
            premierRenewal = 100;
            premierMaint = .1; //Percentage
            premierInspection = 0;
            premierAnnual = (premierSetup+premierMarketing+premierLeasing+(premierMonthly*numMonths)+premierRenewal+premierInspection)*numUnits;
            $('#premier-annual').text(commaSeparateNumber(premierAnnual));
            
            // Calculate Strategic Cost
            strategicSetup = 0;
            strategicMarketing = 0;
            strategicLeasing = .25 * estimatedRent;
            strategicMonthly = .08 * estimatedRent;
            strategicRenewal = 100;
            strategicMaint = .1; //Percentage
            strategicInspection = 0;
            strategicAnnual = (strategicSetup+strategicMarketing+strategicLeasing+(strategicMonthly*numMonths)+strategicRenewal+strategicInspection)*numUnits;
            $('#strategic-annual').text(commaSeparateNumber(strategicAnnual));
        }
        function commaSeparateNumber(val){
          val = Math.round(val);
        while (/(\d+)(\d{3})/.test(val.toString())){
          val = val.toString().replace(/(\d+)(\d{3})/, '$1'+','+'$2');
        }
          val = '$'+val;
        return val;
      }
    
    });
    </script>";
	return $returnText;
}

	

?>