<?php
/**
 * Template Name: Landing Page
 *
 
 */
?>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-NKNHVK');</script>
<!-- End Google Tag Manager -->

<!-- Global site tag (gtag.js) - Google AdWords: 834600635 -->
<script async src="https://www.googletagmanager.com/gtag/js?id=AW-834600635"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'AW-834600635');
</script>

<script>
document.addEventListener( 'wpcf7mailsent', function( event ) {
    ga('send', 'event', 'Contact Form', 'submit');
}, false );
</script>

    <!-- Basic Page Needs

  ================================================== -->

	<meta charset="<?php bloginfo( 'charset' ); ?>">

	<title><?php	     

	    // Page or Single Post

	    if ( is_page() or is_single() ) {

	        the_title();	 

	    // Category Archive

	    } elseif ( is_category() ) {

	        echo single_cat_title('', false);	 

	    // Tag Archive

	    } elseif ( function_exists('is_tag') and function_exists('single_tag_title') and is_tag() ) {

	        printf( __('Tag: %s','Aqua'), single_tag_title('', false) );	 

	    // General Archive

	    } elseif ( is_archive() ) {

	        printf( __('Archive: %s','Aqua'), wp_title('', false) );	 

	    // Search Results

	    } elseif ( is_search() ) {

	        printf( __('Search: %s','Aqua'), get_query_var('s') );

	    }	 

	    // Insert separator for the titles above

	    if ( !is_home() and !is_404() ) {

	        echo " - ";

	    }	     

	    // Finally the blog name

	    bloginfo('name');	 

	    ?></title>



	



	<!-- Mobile Specific Metas

  ================================================== -->

	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">



	<!-- CSS

  ================================================== -->

	<link rel="stylesheet" href="<?php bloginfo( 'stylesheet_url' ); ?>">

	<link href='http://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,400,300,600' rel='stylesheet' type='text/css'>

	

	<?php 

	$fonts_already_loaded = array("Open+Sans");

	$fonts_to_load = array();



	// Load Nav Font 

	if(!in_array(($nav_font = ot_get_option('nav_font_family')), $fonts_already_loaded)) {

		$fonts_to_load[] = $nav_font;

	}

	// Load Headings Font 

	if(!in_array(($heading_font = ot_get_option('heading_font_family')), $fonts_already_loaded)) {

		$fonts_to_load[] = $heading_font;

	}

	// Load Buttons Font 

	if(!in_array(($button_font = ot_get_option('button_font_family')), $fonts_already_loaded)) {

		$fonts_to_load[] = $button_font;

	}

	

	

	

	// Loading fonts

	foreach($fonts_to_load as $font){

		echo "<link href='http://fonts.googleapis.com/css?family=".$font."' rel='stylesheet' type='text/css'>\n\t";

		

	}

	

	

	

	// Apply Dynamic CSS

	echo "<style type='text/css'>";

	

	// Nav font family

	if($nav_font!="Open+Sans"){

		echo "

		#menu {

			font-family: '".str_replace('+',' ',$nav_font)."';

		}\n";		

	}

	// Nav font size

	if(($nav_font_size=ot_get_option('nav_font_size'))!="16px"){

		echo "

		#menu > ul > li > a {

			font-size: ".$nav_font_size.";

		}

		#menu > ul > li ul > li > a {

			font-size: ".((int)(substr($nav_font_size,0,2)) - 2).'px'.";

		}\n";

	}

	// Custom Menu BGR color

	if( (($nav_bgr_color=get_theme_mod('nav_bgr_color'))!="#0ad1e5") && ((get_theme_mod('main_menu_style') == 'custom_menu')||(get_theme_mod('main_menu_style') == 'custom_menu2'))){

		echo "

		.custom_menu #menu, .custom_menu #menu > ul > li > a {

			background-color: ".$nav_bgr_color.";

		}

		.custom_menu2 #menu > ul > li > a:hover, .custom_menu2 #menu > ul > li:hover > a, .custom_menu2 #menu > ul > li ul > li > a:hover > span {

			background-color: ".$nav_bgr_color.";

		}\n";

	}

	

	

	// Main Color

	if(($aqua_main_color=get_theme_mod('aqua_main_color'))!="#0ad1e5"){

		echo '	

		a:hover, a:focus { color: '.$aqua_main_color.' ; }

		.button:hover,a:hover.button,button:hover,input[type="submit"]:hover,input[type="reset"]:hover,	input[type="button"]:hover, .button_hilite, a.button_hilite { color: #fff; background-color: '.$aqua_main_color.' ;}

		.button_hilite, a.button_hilite { color: #fff; background-color: '.$aqua_main_color.' ;}

		.button_hilite:hover, a:hover.button_hilite { color: #fff; background-color: #374045;}

				

		.section_big_title h1 strong { color: '.$aqua_main_color.' ;}

		.section_featured_texts h3 a:hover { color: '.$aqua_main_color.' ;}

				

		.breadcrumb a:hover{ color:  '.$aqua_main_color.' ;}

		.post_meta a:hover{ color:  '.$aqua_main_color.' ;}

		.portfolio_filter div.current{ background-color:  '.$aqua_main_color.' ;}

			   

		.next:hover,.prev:hover{ background-color:  '.$aqua_main_color.' ;}

		.pagination .links a:hover{ background-color:  '.$aqua_main_color.' ;}

		.hilite { background:  '.$aqua_main_color.' ;}

		.price_column.price_column_featured ul li.price_column_title { background:  '.$aqua_main_color.' ;}

		

		.post_description blockquote{ border-left: 4px solid '.$aqua_main_color.'; }

			   

		.info  h2{ background-color:  '.$aqua_main_color.' ;}

		#footer a:hover { color:  '.$aqua_main_color.' ;}

		#footer .boc_latest_post img:hover{ border: 3px solid  '.$aqua_main_color.' ;}

		

		.jcarousel-next-horizontal:hover, .jcarousel-prev-horizontal:hover { background-color: '.$aqua_main_color.' ;}

		'."\n";

	}	

	

	



	// Headings font family

	if($heading_font!="Open+Sans"){

		echo "

		h1, h2, h3, h4, h5, .title, .section_big_title h1, .heading, #footer h3 {

			font-family: '".str_replace('+',' ',$heading_font)."';

		}\n";		

	}	

	// Button font family

	if($button_font!="Open+Sans"){

		echo "

		.button, a.button, button, input[type='submit'], input[type='reset'], input[type='button'] {

			font-family: '".str_replace('+',' ',$button_font)."';

		}\n";		

	}	

	// Body font family

	$body_font = ot_get_option('body_font_family');

	if($body_font!="Open+Sans"){

		echo "

		body {

			font-family: '".str_replace('+',' ',$body_font)."';

		}\n";		

	}	



	// Breadcrumbs

	if(!$boc_breadcrumb = ot_get_option('breadcrumbs')){

		echo "

		.breadcrumb {

			display: none;

		}\n";

	}



	// Custom CSS

	if($boc_custom_css = ot_get_option('custom_css')){

		echo "\n\n".$boc_custom_css."\n";

	}	

	

	

	echo "\t</style>";

	?>

	

	

	<!-- JS

  ================================================== -->	

	

	<?php wp_enqueue_script('jquery'); ?>

	<?php wp_enqueue_script('jquery.easing', get_template_directory_uri().'/js/jquery.easing.1.3.js'); ?>

	<?php wp_enqueue_script('aqua.common', get_template_directory_uri().'/js/aqua.common.js'); ?>

	<?php wp_enqueue_script('jquery.quicksand', get_template_directory_uri().'/js/jquery.quicksand.js'); ?>

	<?php wp_enqueue_script('jquery.flexslider', get_template_directory_uri().'/js/jquery.flexslider-min.js'); ?>

	<?php wp_enqueue_script('jquery.prettyPhoto', get_template_directory_uri().'/js/jquery.prettyPhoto.js'); ?>	

	<?php wp_enqueue_script('jquery.jcarousel', get_template_directory_uri().'/js/jquery.jcarousel.min.js'); ?>

	<?php wp_enqueue_script('jquery.tipsy', get_template_directory_uri().'/js/jquery.tipsy.js'); ?>		

	<!--[if lt IE 9]>

		<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>

	<![endif]-->



	<!-- Favicons

	================================================== -->

	<link rel="icon" type="image/x-icon" href="<?php echo ot_get_option('favicon_uploaded', get_template_directory_uri().'/images/favicon.png')?>">	

	<?php wp_head(); ?>

	

</head>
<body>
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-NKNHVK"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->

<?php


if(isset($_POST['submit'])) {

	if(trim($_POST['comment_name']) == '') {
		$hasError = true;
	} else {
		$name = trim($_POST['comment_name']);
	}

	if(trim($_POST['subject']) == '') {
		$hasError = true;
	} else {
		$subject = trim($_POST['subject']);
	}

	if(trim($_POST['email']) == '')  {
		$hasError = true;
	} else if (!eregi("^[A-Z0-9._%-]+@[A-Z0-9._%-]+\.[A-Z]{2,4}$", trim($_POST['email']))) {
		$hasError = true;
	} else {
		$email = trim($_POST['email']);
	}

	if(trim($_POST['comment']) == '') {
		$hasError = true;
	} else {
		if(function_exists('stripslashes')) {
			$comments = stripslashes(trim($_POST['comment']));
		} else {
			$comments = trim($_POST['comment']);
		}
	}
	
	
	// Send mail if no Errors
	if(!isset($hasError)) {		$emailTo = ot_get_option('contact_page_email');		if (!isset($emailTo) || ($emailTo == '') ){			$emailTo = get_option('admin_email');		}

		$body = "Name: $name \n\nEmail: $email \n\nSubject: $subject \n\nComments:\n $comments";
		$headers = 'From: '.get_bloginfo('name').' <'.$emailTo.'>' . "\r\n" . 'Reply-To: ' . $email;

		$emailSent = wp_mail($emailTo, $subject, $body, $headers);
	}
}
?>
	<?php if(ot_get_option('gmaps_address')): ?>
    
		<div class="row">

			<div class="sixteen columns">
				<div id="google_map">
					<iframe src="https://maps.google.com/maps?f=q&amp;source=s_q&amp;hl=en&amp;geocode=&amp;q=<?php echo urlencode(ot_get_option('gmaps_address')); ?>&amp;aq=&amp;ie=UTF8&amp;hq=&amp;hnear=<?php echo urlencode(ot_get_option('gmaps_address')); ?>&amp;t=m&amp;z=<?php echo ot_get_option('gmaps_zoom',14); ?>&amp;output=embed"></iframe>	
				</div>
			</div>
			
		</div>	

	<?php endif; ?>


	<div class="row padded_block">
		<div class="two-thirds column">
		
		<?php while(have_posts()): the_post(); ?>
			<div id="post-<?php the_ID(); ?>">
				
				<?php the_content(); ?>
				
				<?php if(isset($hasError)) { //If errors are found ?>
					<div class="warning closable"><?php _e("Please make sure all fields are correctly filled in!", 'Aqua'); ?></div>
				<?php } ?>

				<?php if(isset($emailSent) && $emailSent == true) { //If email is sent ?>
					<div class="success closable"><?php _e('Your email was successfully sent! Thank you for contacting us!', 'Aqua'); ?></div>
				<?php } ?>
                    	</div>
		<?php endwhile; ?>
	  </div>

		<div class="one-third column">
			<?php if ( ! dynamic_sidebar('Aqua Contact Sidebar') ) : ?>
			<?php endif; // end sidebar widget area ?>
		</div>
 
      
  </div>
  </body>
  </html>